///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _TCPHANDLER_CPP
#define _TCPHANDLER_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_TCPHandler = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::Start_TCPHandler(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::Start_TCPHandler.\n");
    #endif

    ghEvent_TCPHandler = CreateEvent(NULL, TRUE, FALSE, "TCPHandler_Thread_Function");

    if((hcTCPHandler_Thread_Handle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)TCPHandler_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcTCPHandler_Thread_ID)) == NULL)
    {
        FatalError(__FILE__, __LINE__, "CreateThread failed.");
        CloseHandle(ghEvent_TCPHandler);
        return false;
    }

    if(WaitForSingleObject(ghEvent_TCPHandler, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_TCPHandler);
        return false;
    }

    CloseHandle(ghEvent_TCPHandler);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::Stop_TCPHandler(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::Stop_TCPHandler.\n");
    #endif

    DWORD dwExitCode = 0;

    if(bcTCPHandlerActive)
    {
        bcShutdownTCPHandler = true;

        while(GetExitCodeThread(hcTCPHandler_Thread_Handle, &dwExitCode))
        {
            if(dwExitCode != STILL_ACTIVE)
            {
                CloseHandle(hcTCPHandler_Thread_Handle);
                dwcTCPHandler_Thread_ID = 0;
                return true;
            }
            Sleep(1);
        }

        FatalError(__FILE__, __LINE__, "GetExitCodeThread failed.");

        return false;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI TCPHandler_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> TCPHandler_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
	CSockSrvr* pSockSrvr = (CSockSrvr *) pvThread;

    pSockSrvr->bcShutdownTCPHandler = false;
    pSockSrvr->bcTCPHandlerActive = true;

	pSockSrvr->TimeOut.tv_sec	= 5;
	pSockSrvr->TimeOut.tv_usec = 250;

	FD_ZERO(&pSockSrvr->ReadFDS);
	FD_ZERO(&pSockSrvr->WriteFDS);
	FD_ZERO(&pSockSrvr->ExceptFDS);

    SetEvent(ghEvent_TCPHandler);
    //---------------------(Initialize Thread [END])----------

	int iClient = 0;

    while(!pSockSrvr->bcShutdownTCPHandler)
    {
        // Zero the Read, Write and Except
    	FD_ZERO(&pSockSrvr->ReadFDS);
    	FD_ZERO(&pSockSrvr->WriteFDS);
    	FD_ZERO(&pSockSrvr->ExceptFDS);

        if(!pSockSrvr->IsListeningServer)
        {
            while(pSockSrvr->icCurrentClients == 0)
            {
                if(pSockSrvr->bcShutdownTCPHandler)
                {
                    break;
                }
                Sleep(TCPHANDLER_MS_WAIT);
            }
            if(pSockSrvr->bcShutdownTCPHandler)
            {
                break;
            }
        }
        else {
            // Set LocalListenSocket socket to Read, Except
    		FD_SET(pSockSrvr->sckcListenSocket, &pSockSrvr->ReadFDS);
    		FD_SET(pSockSrvr->sckcListenSocket, &pSockSrvr->ExceptFDS);
        }

		// Set all connected clients to Read, Write and Except
		if(pSockSrvr->icCurrentClients > 0)
		{
			iClient = 0;
			while(iClient < pSockSrvr->icMaxClients)
			{
				if( pSockSrvr->bcConnected[iClient] == true)
				{
					FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ReadFDS);
					FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->WriteFDS);
					FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ExceptFDS);
				}
				iClient++;
			}
		}

		// Socket Select...
		if(select(-1, &pSockSrvr->ReadFDS, &pSockSrvr->WriteFDS, &pSockSrvr->ExceptFDS, &pSockSrvr->TimeOut) == SOCKET_ERROR)
		{
			FatalError(__FILE__, __LINE__, "TCPHandler_Thread_Function :: Scoket select error.");
			return -1;
		}

        if(pSockSrvr->IsListeningServer)
        {
    		// Accept any incoming connections.
		    if(TryEnterCriticalSection(&pSockSrvr->CriticalSection1))
			{
    			pSockSrvr->DoAccept();
				LeaveCriticalSection(&pSockSrvr->CriticalSection1);
			}
        }

		// Send and receive any pending data.
		if(pSockSrvr->icCurrentClients > 0)
		{
    		iClient = 0;
			while(iClient < pSockSrvr->icMaxClients)
			{
				if(pSockSrvr->bcConnected[iClient] == true)
				{
                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->WriteFDS) )
                	{
					    if(TryEnterCriticalSection(&pSockSrvr->CriticalSection1))
						{
	    					pSockSrvr->DoSend(iClient);
							LeaveCriticalSection(&pSockSrvr->CriticalSection1);
						}
                    }

                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ReadFDS) )
                	{
					    if(TryEnterCriticalSection(&pSockSrvr->CriticalSection1))
						{
	    					pSockSrvr->DoRecv(iClient);
							LeaveCriticalSection(&pSockSrvr->CriticalSection1);
						}
                    }

                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ExceptFDS) )
                	{
        				pSockSrvr->bcDisconnect[iClient] = true;
                    }
				}
				iClient++;
			}

    		// Disconnect any pending disconnects.
			if(pSockSrvr->icCurrentClients > 0)
			{
    			iClient = 0;
				while(iClient < pSockSrvr->icMaxClients)
				{
					if( pSockSrvr->bcDisconnect[iClient] == true)
					{
						pSockSrvr->DisconnectClient(iClient);
					}
					iClient++;
				}
			}
		}

        Sleep(TCPHANDLER_MS_WAIT);
	}

    pSockSrvr->bcTCPHandlerActive = false;

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

